/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBWidgetCounter = Object.create(STBModule.prototype);

STBWidgetCounter.name = "WidgetCounter";
STBWidgetCounter.initPlugin = function() {

	var elements = $('.widget-counter-up .counter:not(.__done)');

	if (elements.length > 0) {
		elements.each(function() {

			var el = $(this);



			el.one('inview', function (event, isInView) {
				if (isInView) {
					if (!STBGlobalPreloader.isVisible())	{

						el.counterUp({
							delay: 10,
							time: 1000
						});

					}
				}
			});

			
			//if is visible run it at once
			if (!STBGlobalPreloader.isVisible())	{
				if (STBUtils.isInView(el))	{

					el.counterUp({
						delay: 10,
						time: 200
					});

					el.off("inview");
				}
			} 

			el.addClass("__done");

		});
	}
}


STBWidgetCounter.runOnReady = function() {
	STBWidgetCounter.initPlugin();
}

STBWidgetCounter.runOnContentUpdate = function() {
	STBWidgetCounter.initPlugin();
}

site.registerModule(STBWidgetCounter);